//
//  MCReportUserInputView.h
//  MCReporting
//
//  Created by Alykhan Jetha on 05/03/06.
//  Copyright 2006 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCPObjectContext;
@class MCReportWrapper;

@interface MCReportUserInputView : NSView {
	MCReportWrapper *reportWrapper;
	MCPObjectContext *objectContext; // not retained
	NSArray *viewConfigurations;
	
	id userInputClass; // not retained
}

- (id)initWithFrame:(NSRect)frameRect;
- (id)initWithFrame:(NSRect)frameRect userInputClass:(Class)aClass;

- (MCReportWrapper *)reportWrapper;
- (void)setReportWrapper:(MCReportWrapper *)aReportWrapper;

- (NSArray *)viewConfigurations;
- (void)setViewConfigurations:(NSArray *)aViewConfigurations;

- (void)setObjectContext:(MCPObjectContext *)conn;
- (MCPObjectContext *)objectContext;

// give the config dictionary, rebuilds input views
- (void)rebuildViews;

// resize to fit all subviews (height only)
- (void)sizeToFit;

// return NO if mandataory fields are not in
- (BOOL)validateUserInput;

- (NSDictionary *)userInputs;
- (void)setUserInputs:(NSDictionary *)aDictionary; // [MO] for DRS prefpane

- (NSArray *)elementNamesToExclude;
- (void)setElementNamesToExclude:(NSArray *)anArray; // [MO] for DRS prefpane


// return MCReportUserInput <thefilename.extension> or nil if no filewrapper can be found
- (NSString *)basicDefaultsName;

@end
